/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// After upgrading to Windows 10 this shader stopped working.  As part of the
// investigation as to why I deleted all of the unused functions that were in
// this source file and did some other minor changes. After finding the cause
// of the problem I kept the changes even though they made no difference. The
// problem was in the function t1 and seems to be an Intel compiler error.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(cos(time/10.0),0.0)
#define surfacePosition vec2(2.0*gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// winning! menger's sponge pattern discovered

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// varying vec2 surfacePosition;

float t = 1.0*time;
float pi = atan(1.0)*4.0;

//#define MAX_ITER 41
#define MAX_ITER 8

mat2 complexz ( float zr, float zi ) { return mat2(zr,-zi,zi,zr); }
mat2 complexp ( float zl, float zp ) { return complexz(zl*cos(zp),zl*sin(zp)); }

float RZ ( mat2 z ) { return z[0][0]; }
float IZ ( mat2 z ) { return z[0][1]; }

float LZ ( mat2 z ) { return length ( vec2(RZ(z), IZ(z)) ); }
float PZ ( mat2 z ) { return atan   ( IZ(z), RZ(z) ); }

mat2  CZ ( mat2 z ) { return complexz ( RZ(z), -IZ(z) ); }

mat2 cdiv(mat2 z1, mat2 z2)
{
   float  x2 = RZ(z2); float y2 = IZ(z2);
   float  l2 = x2*x2 + y2*y2;
   return z1 * complexz ( x2/l2, -y2/l2 );
}

mat2 CE = complexz(1.0,0.0);
mat2 CI = complexz(0.0,1.0);

mat2 ccos ( mat2 z ) 
{
   float x = RZ(z); float y = IZ(z);
   return (cos(x)*cosh(y))*CE + (sin(x)*sinh(y))*CI;
}
mat2 csin ( mat2 z )
{
   float x = RZ(z); float y = IZ(z);
   return (sin(x)*cosh(y))*CE - (cos(x)*sinh(y))*CI;
}

mat2 cexp(mat2 z)
{
   float x = RZ(z); float y = IZ(z);
   return exp(x) * ( cos(y)*CE + sin(y)*CI );
}

mat2 cln ( mat2 z )
{
   float x = RZ(z); float y = IZ(z);
   return complexz ( 0.5*log(x*x+y*y) , atan(y,x) );
}

mat2 cpow ( mat2 z, mat2 w ) { return cexp(w*cln(z)); }
mat2 ctan ( mat2 z ) { return cdiv(csin(z),ccos(z)); }

mat2 t1 ( mat2 z )
{
// The original form of this function using
//   return z - ( cdiv(CE,(CE+z*z)) + CE*2.0*(mouse.x-0.5) );
// failed with my Intel Integrated Graphics processor after
// upgrading to Windows 10.  However,  the  following works
   return z - ( cdiv(CE,(CE+z*z)) + CE*(mouse.x*2.0-1.0) );
// This must be an Intel compiler error. TheEmu.
} 

mat2 fpre ( mat2 z )
{
	return z;
}

mat2 fpost ( mat2 z )
{
	mat2 w = ctan(z);
	return cpow(w,CI);
}

void main ( void )
{
   float x = gl_FragCoord.x;
   float y = gl_FragCoord.y;

   float w = resolution.x;
   float h = resolution.y;

   vec2 sp = surfacePosition.xy * 10.0;

   mat2 fn = fpre ( complexz(sp.x,sp.y) );

   for ( int n=0; n<MAX_ITER; n++ )
    { 
      fn = t1(fn);
    }

   mat2 f = fpost(fn);

   float phase = PZ(f) / pi;

   float c1 = abs(phase);
   float c2 = c1 * 2.0;
   float c3 = c2 - 1.0;

   vec3 color = vec3(0.0);

   if ( phase>=0.0 && phase<= 0.5 ) { color = vec3 ( c2, 0., 0. ); }
   if ( phase> 0.5 && phase<= 1.0 ) { color = vec3 ( 1., c3, c3 ); }
   if ( phase< 0.0 && phase>=-0.5 ) { color = vec3 ( 0., c2, 0. ); }
   if ( phase<-0.5 && phase> -1.0 ) { color = vec3 ( c3, 1., c3 ); }

   gl_FragColor = vec4 ( color, length(color) );

}